% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdis_mp.R
\name{hdis_mp}
\alias{hdis_mp}
\title{Discord discovery using Matrix Profile}
\usage{
hdis_mp(mode = "stamp", w, qtd)
}
\arguments{
\item{mode}{mode of computing distance between sequences. Available options include: "stomp", "stamp", "simple", "mstomp", "scrimp", "valmod", "pmp"}

\item{w}{word size}

\item{qtd}{number of occurrences to be classified as discords}
}
\value{
\code{hdis_mp} object
}
\description{
Discord discovery using Matrix Profile \url{doi:10.32614/RJ-2020-021}
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_motifs)

#Using sequence example
dataset <- examples_motifs$simple
head(dataset)

# setting up discord discovery method
model <- hdis_mp("stamp", 4, 3)

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
