% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{get_data_classes}
\alias{get_data_classes}
\title{Extract data classes from a data frame or matrix}
\usage{
get_data_classes(data)
}
\arguments{
\item{data}{A data frame or matrix.}
}
\value{
A named list. The names are the column names of \code{data} and the values are
character vectors containing the class of that column.
}
\description{
When predicting from a model, it is often important for the \code{new_data} to
have the same classes as the original data used to fit the model.
\code{get_data_classes()} extracts the classes from the original training data.
}
\examples{
get_data_classes(iris)

get_data_classes(as.matrix(mtcars))

# Unlike .MFclass(), the full class
# vector is returned
data <- data.frame(col = ordered(c("a", "b")))

.MFclass(data$col)

get_data_classes(data)
}
