% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunHarmony.R
\name{RunHarmony}
\alias{RunHarmony}
\title{Generic function that runs the harmony algorithm on single-cell
genomics cell embeddings.}
\usage{
RunHarmony(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=RunHarmony.default]{RunHarmony.default}}
  \describe{
    \item{\code{theta}}{Diversity clustering penalty parameter. Specify for
each variable in vars_use Default theta=2. theta=0 does not
encourage any diversity. Larger values of theta result in more
diverse clusters.}
    \item{\code{sigma}}{Width of soft kmeans clusters. Default
sigma=0.1. Sigma scales the distance from a cell to cluster
centroids. Larger values of sigma result in cells assigned to
more clusters. Smaller values of sigma make soft kmeans cluster
approach hard clustering.}
    \item{\code{lambda}}{Ridge regression penalty. Default lambda=1. Bigger
values protect against over correction. If several covariates
are specified, then lambda can also be a vector which needs to
be equal length with the number of variables to be
corrected. In this scenario, each covariate level group will be
assigned the scalars specified by the user. If set to NULL,
harmony will start lambda estimation mode to determine lambdas
automatically and try to minimize overcorrection (Use with caution still
in beta testing).}
    \item{\code{nclust}}{Number of clusters in model. nclust=1 equivalent to
simple linear regression.}
    \item{\code{max_iter}}{Maximum number of rounds to run Harmony. One round
of Harmony involves one clustering and one correction step.}
    \item{\code{early_stop}}{Enable early stopping for harmony. The
harmonization process will stop when the change of objective
function between corrections drops below 1e-4}
    \item{\code{ncores}}{Number of processors to be used for math operations
when optimized BLAS is available. If BLAS is not supporting
multithreaded then this option has no effect. By default,
ncore=1 which runs as a single-threaded process. Although
Harmony supports multiple cores, it is not optimized for
multithreading. Increase this number for large datasets iff
single-core performance is not adequate.}
    \item{\code{plot_convergence}}{Whether to print the convergence plot of
the clustering objective function. TRUE to plot, FALSE to
suppress. This can be useful for debugging.}
    \item{\code{verbose}}{Whether to print progress messages. TRUE to print,
FALSE to suppress.}
    \item{\code{.options}}{Advanced parameters of RunHarmony. This must be the
result from a call to `harmony_options`. See ?`harmony_options`
for more details.}
  }}
}
\value{
If used with single-cell objects, it will return the
updated single-sell object. For standalone operation, it
returns the corrected cell embeddings or the R6 harmony object
(see \code{\link[=RunHarmony.default]{RunHarmony.default()}}).
}
\description{
RunHarmony is generic function that runs the main Harmony
algorithm. If working with single cell R objects, please refer to
the documentation of the appropriate generic API:
(\code{\link[=RunHarmony.Seurat]{RunHarmony.Seurat()}} or \code{\link[=RunHarmony.SingleCellExperiment]{RunHarmony.SingleCellExperiment()}}). If
users work with other forms of cell embeddings, the can pass them
directly to harmony using \code{\link[=RunHarmony.default]{RunHarmony.default()}} API. All the
function arguments listed here are common in all RunHarmony
interfaces.
}
\seealso{
Other RunHarmony: 
\code{\link{RunHarmony.Seurat}()},
\code{\link{RunHarmony.SingleCellExperiment}()},
\code{\link{RunHarmony.default}()}
}
\concept{RunHarmony}
