\name{hash}

\alias{hash}

\title{hash/associative array/dictionary data structure for the R language}

\description{

  Preferred constructor for the \code{\link{hash-class}}.
  
}

\usage{
  hash(...)
}

\arguments{
  \item{...}{ Specification of keys and values.  }
}

\details{

  \code{hash} returns a hash object.  Key-value pairs may be specified
  via the \code{...} argument as explicity arguments \code{keys} and
  \code{values}, as named key-value pairs, as a named vector or as implicit
  key, value vectors.  See examples below for each type.  
  
  Keys and must be coercable to a character vector. Values are restricted
  to to valid R objects.

  See \code{\link{.set}} for further details and how key-value vectors of 
  unequal length are interpretted.

  Hashes may be accessed via the standard R accessors \code{[}, \code{[[} 
  and \code{\$}.  See \code{\link{hash-accessors}} for details.
  
}

\value{
  An object of class hash.   
}

\author{ Christopher Brown }
\seealso{ \code{\link{.set}}, \code{\link{hash-accessors}} }

\examples{

    hash()

	hash( key=letters, values=1:26 )
	
	hash( 1:3, lapply(1:3, seq, 1 ))
	
	hash( a=1, b=2, c=3 )
	hash( c(a=1, b=2, c=3) ) 
	hash( list(a=1,b=2,c=3) )

	hash( c("foo","bar","baz"), 1:3 )
	hash( c("foo","bar","baz"),  lapply(1:3, seq, 1 ) )
    hash( letters, 1:26 )

    h <- hash( letters, 1:26 )
	h$a
	h$b
	h[[ "a" ]]
	h[ letters[1:3] ]

	h$a<-100
	h[['a']]<-letters

}

\keyword{ data }
\keyword{ manip }
