% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_phenology.R
\name{predict_phenology}
\alias{predict_phenology}
\title{Predict phenology of fish}
\usage{
predict_phenology(data, dates, temperature, spawn.date, model)
}
\arguments{
\item{data}{Data frame with dates and temperature.}

\item{dates}{Date of temperature measurements.}

\item{temperature}{Temperature measurements.}

\item{spawn.date}{Date of spawning, given as a character string
(e.g., "1990-08-18"). Must be year-month-day in format shown.}

\item{model}{A data.frame with a column named "expression" or a character vector
giving model specifications. Can be obtained using \code{model_select()}
or using you own data to obtain a model expression (see \code{fit_model}).}
}
\value{
A list with the following elements:
\itemize{
\item \code{days_to_develop}: A numeric vector of length 1; number of predicted
days to hatch or emerge.
\item \code{ef_table}: An n x 4 tibble (n = number of days to hatch or emerge) with
the dates, temperature, effective values, and cumulative sum of the
effective values.
\item \code{dev.period}: a 1x2 dataframe with the dates corresponding to when your
fish's parent spawned (input with \code{predict_phenology(spawn.date = ...)})
and the date when the fish is predicted to hatch or emerge.
\item \code{model_specs}: A data.frame with the model specifications.
}
}
\description{
Predict the phenology of fish using the effective value framework.
}
\examples{
library(hatchR)
# get model parameterization
sockeye_hatch_mod <- model_select(
  author = "Beacham and Murray 1990",
  species = "sockeye",
  model_id = 2,
  development_type = "hatch"
)

# predict phenology
sockeye_hatch <- predict_phenology(
  data = woody_island,
  dates = date,
  temperature = temp_c,
  spawn.date = "1990-08-18",
  model = sockeye_hatch_mod
)
}
\references{
Sparks, M.M., Falke, J.A., Quinn, T.A., Adkinson, M.D.,
Schindler, D.E. (2019). Influences of spawning timing, water temperature,
and climatic warming on early life history phenology in western
Alaska sockeye salmon.
\emph{Canadian Journal of Fisheries and Aquatic Sciences},
\bold{76(1)}, 123--135.
}
