% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whittle.R
\name{whittle}
\alias{whittle}
\title{Fitting Hawkes processes from discrete data}
\usage{
whittle(counts, kern, binsize = NULL, trunc = 5L, init = NULL, ...)
}
\arguments{
\item{counts}{A bin-count sequence}

\item{kern}{Either a string (partially) matching one of the kernels implemented (see Details), or an object of class Model}

\item{binsize}{(Optional) The bin size of the bin-count sequence; if omitted, defaults to 1 if \code{kern} is a string, or uses the member \code{binsize} of \code{kern} if it is of class Model}

\item{trunc}{(Optional) The number of foldings taken into account due to aliasing}

\item{init}{(Optional) Initial values of the optimisation algorithm}

\item{...}{Additional arguments passed to \code{optim}}
}
\value{
Returns a list containing the solution of the optimisation procedure, the object Model
with its parameters updated to the solution, and the output produced by \code{optim}.
}
\description{
This function fits a Hawkes process to discrete data by minimizing the Whittle contrast.
}
\details{
If specified as string, the argument \code{kern} must match (partially) one of the following
(upper cases not taken into account): Exponential, SymmetricExponential,
Gaussian, PowerLaw, Pareto3, Pareto2, Pareto1.
The periodogram used in the optimisation procedure is computed in complexity
\eqn{O(n \log n)}, using function \code{fft}.
}
\examples{
# Simulate and fit a Hawkes process with exponential kernel
x = hawkes(1000, fun = 1, repr = .5, family = "exp", rate = 1)
y = discrete(x, binsize = 1)
opt = whittle(y, "Exponential")
opt$par      # Estimated parameters

\donttest{
# May take up to 20 seconds
# Simulate and fit a Hawkes process with power law kernel
x = hawkes(1000, fun = 1, repr= .3, family = "powerlaw", shape = 3.5, scale = 1.0)
y = discrete(x, binsize = 1)
opt = whittle(y, "powerlaw")
opt$par      # Estimated parameters
}
}
\seealso{
\code{\link[=hawkes]{hawkes()}} for the simulation of Hawkes processes,
\code{\link[=discrete]{discrete()}} for the discretisation of simulated Hawkes processes,
\link{Model} for the abstract class, and \link{Exponential} for the specific
reproduction kernels.
}
