% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossValidate.R
\name{crossValidate}
\alias{crossValidate}
\keyword{internal}
\title{Ridge Penalty Selection through Cross Validation}
\usage{
crossValidate(
  group.alpha = NULL,
  penalty.pos = NULL,
  penalty.val = NULL,
  group.exact = NULL,
  grouping = NULL,
  folds = NULL,
  treatment = NULL,
  fold.co = NULL,
  fold.tr = NULL,
  coefs = NULL,
  control = NULL,
  constraint.tolerance = NULL,
  print.level = NULL,
  base.weight = NULL,
  full.t = NULL,
  full.c = NULL,
  shuffle.treat = NULL
)
}
\arguments{
\item{group.alpha}{group.alpha. Controls degree of regularization.}

\item{penalty.pos}{positions of user-supplied penalties.}

\item{penalty.val}{values of user-supplied penalties.}

\item{group.exact}{binary indicator of whether each covariate group should be penalized.}

\item{grouping}{different groupings of the covariates.}

\item{folds}{number of folds to perform cross validation.}

\item{treatment}{covariate matrix for treatment group.}

\item{fold.co}{fold assignments for control units.}

\item{fold.tr}{fold assignments for treated units.}

\item{coefs}{starting coefficients (lambda).}

\item{control}{covariate matrix for control group.}

\item{constraint.tolerance}{tolerance level for imbalance.}

\item{print.level}{details of printed output.}

\item{base.weight}{target weight distribution for the control units.}

\item{full.t}{(unresidualized) ovariate matrix for treatment group.}

\item{full.c}{(unresidualized) ovariate matrix for control group.}

\item{shuffle.treat}{whether to create folds for the treated units}
}
\value{
group.alpha, lambda
}
\description{
Internal function called by \code{hbal} to select ridge penalties through cross-validation.
}
\author{
Yiqing Xu, Eddie Yang
}
