% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data_cv.R
\name{prep_data_cv}
\alias{prep_data_cv}
\title{Prepare data for a K-fold cross-validation of an HBAM model}
\usage{
prep_data_cv(data, K = 10, seed = 1)
}
\arguments{
\item{data}{A list of data produced by \code{prep_data}.}

\item{K}{An integer above 2, specifying the number of folds to use in the analysis. Defaults to 10.}

\item{seed}{An integer passed on to \code{set.seed} before creating the folds to increase reproducibility. Defaults to 1.}
}
\value{
A list of K data objects where each version includes a different vector identifying holdout-data.
}
\description{
This function turns data prepared for \code{hbam} into a list of K versions, where each version includes a different vector identifying holdout-data.
}
\examples{
# Loading and re-coding ANES 1980 data:
data(LC1980)
LC1980[LC1980 == 0 | LC1980 == 8 | LC1980 == 9] <- NA
self <- LC1980[, 1]
stimuli <- LC1980[, -1]
dat <- prep_data(self, stimuli)

# Prepare data for cross-validation:
dat_cv <- prep_data_cv(dat, K = 10)

}
