% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRMM.R
\name{TRMM}
\alias{TRMM}
\title{Download and convert TRMM data}
\usage{
TRMM(inputLocation = NULL, product = "3B43", version = 7,
  type = "precipitation.accum", twindow = NULL, areaBox = NULL,
  outputfileLocation = NULL)
}
\arguments{
\item{inputLocation}{location where data is stored. By default it points to the TRMM ftp server (\url{ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/}) but it can also be a local directory. If you are using a local directory, this function expects to find inside 'inputLocation' a folder with the name of product and version (e.g. "i3B43_V7") and inside this a folder for each year( e.g. "2012").}

\item{product}{this is the code that identifies a product, default is "3B43"}

\item{version}{this is the version number, default is 7}

\item{type}{this is the type of information needed, default is "precipitation.accum". Other types could be "gaugeRelativeWeighting.bin" and "relativeError.bin"}

\item{twindow}{is a vector of dates and times for which the data should be retrieve}

\item{areaBox}{OPTIONAL bounding box, a list made of 4 elements: minimum longitude (xmin), minimum latitude (ymin), maximum longitude (xmax), maximum latitude (ymax)}

\item{outputfileLocation}{file path where to save the GeoTiff}
}
\value{
Data is loaded as multilayer GeoTIFF and loaded as a RasterBrick.
}
\description{
The TRMM dataset provide global historical rainfall estimation in a gridded format.
}
\details{
This code is based upon Martin Brandt's blog post:
\url{http://matinbrandt.wordpress.com/2013/09/04/automatically-downloading-and-processing-trmm-rainfall-data/}
and on the TRMM FAQ: \url{http://disc.sci.gsfc.nasa.gov/additional/faq/precipitation_faq.shtml}
}
\examples{
\dontrun{
  # Define a bounding box
  areaBox <- raster::extent(-10, 5, 48, 62)
  twindow <- seq(as.Date("2012-01-01"), as.Date("2012-01-31"), by = "months")

  TRMMfile <- TRMM(product = "3B43", version = 7,
                   type = "precipitation.accum",
                   twindow = twindow, areaBox = areaBox)

  raster::plot(TRMMfile)
}

}
\author{
Claudia Vitolo
}

