% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5Open}
\alias{h5Open}
\alias{h5Open.H5Group}
\alias{h5Open.H5File}
\alias{h5Open.character}
\title{Open an HDF5 file, file-handler or group object}
\usage{
h5Open(x, name, ...)

\method{h5Open}{H5Group}(x, name, ...)

\method{h5Open}{H5File}(x, name, ...)

\method{h5Open}{character}(x, name, mode = c("a", "r", "r+", "w", "w-", "x"), ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{name}{Name of the opened HDF5 link.}

\item{...}{Arguments passed to \code{H5Group$open()}.}

\item{mode}{Passed to \code{\link{h5TryOpen}}}
}
\value{
An opened \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} 
or \code{\link[hdf5r]{H5D}}.
}
\description{
Open an HDF5 file, file-handler or group object
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
obs <- h5Open(file, "obs")
stopifnot(inherits(obs, "H5Group"))
tsne <- h5Open(file, "obsm/tsne")
stopifnot(inherits(tsne, "H5D"))

}
