% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5Exists}
\alias{h5Exists}
\alias{h5Exists.H5Group}
\alias{h5Exists.H5File}
\alias{h5Exists.character}
\title{Check existence of an HDF5 link}
\usage{
h5Exists(x, name, ...)

\method{h5Exists}{H5Group}(x, name, ...)

\method{h5Exists}{H5File}(x, name, ...)

\method{h5Exists}{character}(x, name, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file}

\item{name}{Name of HDF5 link to be checked.}

\item{...}{Arguments passed to \code{H5File$exists()}}
}
\value{
If any parent directory of \code{name} doesn't exist, will simply 
return \code{FALSE}
}
\description{
Check existence of an HDF5 link
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
h5Exists(file, "/")
h5Exists(file, "obs")
h5Exists(file, "X")

h5fh <- h5TryOpen(file, mode = "r")
h5Exists(h5fh, "obs")

h5obj <- h5Open(h5fh, "obs")
h5Exists(h5obj, "groups")

}
