% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gmu_lasso.R
\name{plot.gmu_lasso}
\alias{plot.gmu_lasso}
\title{Plot the estimates returned by gmu_lasso}
\usage{
\method{plot}{gmu_lasso}(x, ...)
}
\arguments{
\item{x}{An object of class gmu_lasso}

\item{...}{Other arguments to plot (not used).}
}
\description{
Plot the number of nonzero coefficients along a range of delta
  values if delta has length larger than 1, or the estimated coefficients of
  delta has length 1.
}
\examples{
set.seed(1)
n <- 200
p <- 50
s <- 10
beta <- c(rep(1,s),rep(0,p-s))
sdU <- 0.2

X <- matrix(rnorm(n*p),nrow = n,ncol = p)
W <- X + sdU * matrix(rnorm(n * p), nrow = n, ncol = p)

y <- rbinom(n, 1, (1 + exp(-X\%*\%beta))**(-1))
gmu_lasso <- gmu_lasso(W, y)

plot(gmu_lasso)

}
