% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hdnom.nomogram.R
\name{hdnom.nomogram}
\alias{hdnom.nomogram}
\title{Nomograms for High-Dimensional Cox models}
\usage{
hdnom.nomogram(object, x, time, event, ddist, lambda = NULL, pred.at = NULL,
  fun.at = NULL, funlabel = NULL)
}
\arguments{
\item{object}{Fitted \code{glmnet} model object.}

\item{x}{Matrix of training data used for the \code{glmnet} object.}

\item{time}{Survival time.
Must be of the same length with the number of rows as \code{x}.}

\item{event}{Status indicator, normally 0 = alive, 1 = dead.
Must be of the same length with the number of rows as \code{x}.}

\item{ddist}{Data frame version of x, made by \code{\link[rms]{datadist}}.}

\item{lambda}{Value of the penalty parameter lambda in
\code{\link[glmnet]{glmnet}}.
We will use the selected variables at the provided \code{s} to
build the nomogram, and make predictions.
See the example for choosing a proper lambda value extracted
from cross-validation results.}

\item{pred.at}{Time point at which to plot nomogram prediction axis.}

\item{fun.at}{Function values to label on axis.}

\item{funlabel}{Label for \code{fun} axis.}

\item{...}{Other arguments for \code{\link[rms]{nomogram}}.}
}
\description{
Nomograms for High-Dimensional Cox models
}
\examples{
library("glmnet")
library("survival")
library("rms")

# Load imputed SMART data
data(smart)
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Fit penalized Cox model (lasso penalty) with glmnet
set.seed(1010)
cvfit = cv.glmnet(x, Surv(time, event), family = "cox", nfolds = 10)
fit = glmnet(x, Surv(time, event), family = "cox")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(fit, x, time, event, x.df,
                     lambda = cvfit$lambda.1se, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")

print(nom)
plot(nom)
}

