% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.hdnom.models.R
\name{print.hdcox.model}
\alias{print.hdcox.model}
\title{Print High-Dimensional Cox Model Objects}
\usage{
\method{print}{hdcox.model}(x, ...)
}
\arguments{
\item{x}{Model object fitted by \code{hdcox.*()} functions.}

\item{...}{Other parameters (not used).}
}
\description{
Print information about high-dimensional Cox models.
}
\examples{
library("survival")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

lassofit = hdcox.lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)
print(lassofit)
}

