% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1_model.R
\name{fit_lasso}
\alias{fit_lasso}
\title{Model selection for high-dimensional Cox models with lasso penalty}
\usage{
fit_lasso(x, y, nfolds = 5L, rule = c("lambda.min", "lambda.1se"),
  seed = 1001)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}}
for details.}

\item{seed}{A random seed for cross-validation fold division.}
}
\description{
Automatic model selection for high-dimensional Cox models
with lasso penalty, evaluated by penalized partial-likelihood.
}
\examples{
data("smart")
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT
y <- survival::Surv(time, event)

fit <- fit_lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)

nom <- as_nomogram(
  fit, x, time, event,
  pred.at = 365 * 2,
  funlabel = "2-Year Overall Survival Probability"
)

plot(nom)
}
