% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connections.R
\name{db_read}
\alias{db_read}
\title{Read from a SQL Server database table}
\usage{
db_read(con, query, pull_into_memory = TRUE)
}
\arguments{
\item{con}{An odbc database connection. Can be made using
\code{build_connection_string}. Required.}

\item{query}{A string, quoted, required. This sql query will be executed
against the database you are connected to.}

\item{pull_into_memory}{Logical, optional, defaults to TRUE. If FALSE,
\code{db_read} will create a reference to the queried data rather than
pulling into memory. Set to FALSE for very large tables.}
}
\value{
A tibble of data or reference to the table.
}
\description{
Use a database connection to read from an existing SQL Server
table with a SQL query.
}
\details{
Use \code{pull_into_memory} when working with large tables.
Rather than returning the data into memory, this
function will return a reference to the specified query. It will be executed
only when needed, in a "lazy" style. Or, you can execute using the
\code{collect()} function.
}
\examples{
\dontrun{
my_con <- build_connection_string(server = "HPHI-EDWDEV")
con <- DBI::dbConnect(odbc::odbc(), .connection_string = my_con)
d <- db_read(con,
             "SELECT TOP 10 * FROM [Shared].[Cost].[FacilityAccountCost]")

# Get a reference and collect later
ref <- db_read(con,
               "SELECT TOP 10 * FROM [Shared].[Cost].[FacilityAccountCost]",
               pull_into_memory = FALSE)
d <- collect(ref)
}

}
\seealso{
\code{\link{build_connection_string}}
}
