% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connections.R
\name{build_connection_string}
\alias{build_connection_string}
\title{Build a connection string for use with MSSQL and dbConnect}
\usage{
build_connection_string(server, driver = "SQL Server", database,
  trusted = TRUE, user_id, password)
}
\arguments{
\item{server}{A string, quoted, required. The name of the server you are
trying to connect to.}

\item{driver}{A string, quoted, optional. Defaults to "SQL Server", but use
any driver you like.}

\item{database}{A string, quoted, optional. If provided, connection string
will include a specific database. If NA (default), it will connect to master
and you'll have to specify the database when running a query.}

\item{trusted}{Logical, optional, defaults to TRUE. If FALSE, you must use a
user_id and password.}

\item{user_id}{A string, quoted, optional. Don't include if using trusted.}

\item{password}{A string, quoted, optional. Don't include if using trusted.}
}
\value{
A connection string
}
\description{
Handy utility to build a connection string to pass into
\code{DBI::dbConnect}. Accepts trusted connections or username/password.
}
\examples{
\dontrun{
my_con <- build_connection_string(server = "localhost")
con <- DBI::dbConnect(odbc::odbc(), .connection_string = my_con)

# with username and password
my_con <- build_connection_string(server = "localhost",
                                  user_id = "jules.winnfield",
                                  password = "pathoftherighteous")
con <- DBI::dbConnect(odbc::odbc(), .connection_string = my_con)
}
}
\seealso{
\code{\link{db_read}}
}
