% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{IndividualSample}
\alias{IndividualSample}
\title{World Health Organization (WHO)}
\format{
\subsection{\code{IndividualSample}}{

A data frame with 17,848 rows and 10 columns:
\describe{
\item{id}{individual identifier}
\item{psu}{Primary Sample Unit (PSU)}
\item{strata}{sampling strata}
\item{weight}{sampling weight}
\item{subgroup}{subgroup name}
\item{subgroup_order}{subgroup order}
\item{sba}{indicator estimate}
\item{dtp3}{indicator estimate}
\item{favourable_indicator}{favourable (1) or non-favourable (0) indicator}
\item{indicator_scale}{scale of the indicator}
}
}
}
\source{
WHO Health Inequality Data Repository\url{https://www.who.int/data/inequality-monitor/data}
}
\usage{
IndividualSample
}
\description{
This dataset contains sample data for computing non-ordered summary measures
of health inequality. It contains data from a household survey for two
indicators, births attended by skilled health personnel (sba) and Diphtheria
tetanus toxoid and pertussis (DTP3) immunization coverage, disaggregated by
economic status. Both indicators are binary, (1) for those who had sba or dpt3
or (0) if the had not.
}
\details{
Births attended by skilled health personnel is defined as a birth attended
by skilled health personnel divided by the total number of live births to
women aged 15-49 years occurring in the period prior to the survey.
Skilled health personnel include doctors, nurses, midwives and other
medically trained personnel, as defined according to each country. DPT3 is
measured among one-year-olds and indicate those who have received three doses
of the combined diphtheria, tetanus toxoid and pertussis containing vaccine
in a given year.This is in line with the definition used by the Countdown to
2030 Collaboration, Demographic and Health Surveys (DHS), Multiple Indicator
Cluster Surveys (MICS) and Reproductive Health Surveys (RHS).

Economic status is determined using a wealth index, which is based on owning
selected assets and having access to certain services. The wealth index is
divided into five equal subgroups (quintiles) that each account for 20\% of
the population. Economic status is an ordered dimension (meaning that the
subgroups have an inherent ordering).

This dataset can be used to calculate ordered summary measures of health
inequality, including: absolute concentration index (ACI), relative
concentration index (RCI), slope index of inequality (SII) and relative
index of inequality (RII).
}
\examples{
head(IndividualSample)
summary(IndividualSample)
}
\keyword{datasets}
