% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rci.R
\name{rci}
\alias{rci}
\title{Relative concentration index (RCI)}
\usage{
rci(
  est,
  subgroup_order,
  scaleval = NULL,
  pop = NULL,
  weight = NULL,
  psu = NULL,
  strata = NULL,
  fpc = NULL,
  method = NULL,
  lmin = NULL,
  lmax = NULL,
  conf.level = 0.95,
  force = FALSE,
  ...
)
}
\arguments{
\item{est}{The subgroup estimate. Estimates must be
available for all subgroups.}

\item{subgroup_order}{The order of subgroups in an increasing sequence.}

\item{scaleval}{The scale of the indicator. For example, the
scale of an indicator measured as a percentage is 100. The
scale of an indicator measured as a rate per 1000 population is 1000.}

\item{pop}{The number of people within each subgroup.
Population size must be available for all subgroups.}

\item{weight}{Individual sampling weight (required if data come from a
survey)}

\item{psu}{Primary sampling unit (required if data come from a survey)}

\item{strata}{Strata (required if data come from a survey)}

\item{fpc}{Finite population correction}

\item{method}{Normalisation method for bounded indicators. Options available
Wagstaff (\code{wagstaff}) or Erreygers (\code{erreygers}) correction.}

\item{lmin}{Theoretical minimum for bounded indicators.}

\item{lmax}{Theoretical maximum for bounded indicators.}

\item{conf.level}{confidence level of the interval.}

\item{force}{TRUE/FALSE statement to force calculation with missing
indicator estimate values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated RCI value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The relative concentration index (RCI) is a relative measure of inequality
that shows the gradient across population subgroups. It indicates the extent
to which an indicator is concentrated among disadvantaged or advantaged
subgroups, on a relative scale. RCI can be calculated using disaggregated
data and individual-level data. Subgroups in disaggregated data are weighted
according to their population share, while individuals are weighted by
sample weight in the case of data from surveys.
}
\details{
RCI is calculated by dividing the absolute concentration index (ACI)
by the setting average. RCI may be more easily interpreted
when multiplied by 100. The calculation of ACI is based on a
ranking of the whole population from the most-disadvantaged
subgroup (at rank 0) to the most-advantaged subgroup (at rank 1),
which is inferred from the ranking and size of the subgroups.
For more information on this inequality measure see
Schlotheuber, A., & Hosseinpoor, A. R. (2022) below.

\strong{Interpretation:} RCI is bounded between -1 and +1 (or between -100
and +100, when multiplied by 100). The larger the absolute value of RCI,
the higher the level of inequality. For favourable indicators, positive
values indicate a concentration of the indicator among the advantaged,
while negative values indicate a concentration of the indicator among
the disadvantaged. For adverse indicators, it is the reverse: positive
values indicate a concentration of the indicator among the disadvantaged,
while negative values indicate a concentration of the indicator among the
advantaged. RCI is zero if there is no inequality.

\strong{Type of summary measure:} Complex; relative; weighted

\strong{Applicability:} Ordered; more than two subgroups

\strong{Warning:} The confidence intervals are approximate
and might be biased.
}
\examples{
# example code
data(IndividualSample)
head(IndividualSample)
with(IndividualSample,
     rci(est = sba,
         subgroup_order = subgroup_order,
         weight = weight,
         psu = psu,
         strata = strata
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.
}
