% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hai-data-transform.R
\name{hai_data_transform}
\alias{hai_data_transform}
\title{Data Preprocessor - Transformation Functions}
\usage{
hai_data_transform(
  .recipe_object = NULL,
  ...,
  .type_of_scale = "log",
  .bc_limits = c(-5, 5),
  .bc_num_unique = 5,
  .bs_deg_free = NULL,
  .bs_degree = 3,
  .log_base = exp(1),
  .log_offset = 0,
  .logit_offset = 0,
  .ns_deg_free = 2,
  .rel_shift = 0,
  .rel_reverse = FALSE,
  .rel_smooth = FALSE,
  .yj_limits = c(-5, 5),
  .yj_num_unique = 5
)
}
\arguments{
\item{.recipe_object}{The data that you want to process}

\item{...}{One or more selector functions to choose variables to be imputed.
When used with imp_vars, these dots indicate which variables are used to
predict the missing data in each variable. See selections() for more details}

\item{.type_of_scale}{This is a quoted argument and can be one of the following:
\itemize{
\item "boxcox"
\item "bs"
\item "log"
\item "logit"
\item "ns"
\item "relu"
\item "sqrt"
\item "yeojohnson
}}

\item{.bc_limits}{A length 2 numeric vector defining the range to compute the
transformation parameter lambda.}

\item{.bc_num_unique}{An integer to specify minimum required unique values to
evaluate for a transformation}

\item{.bs_deg_free}{The degrees of freedom for the spline. As the degrees of
freedom for a spline increase, more flexible and complex curves can be
generated. When a single degree of freedom is used, the result is a rescaled
version of the original data.}

\item{.bs_degree}{Degree of polynomial spline (integer).}

\item{.log_base}{A numberic value for the base.}

\item{.log_offset}{An optional value to add to the data prior to logging (to avoid log(0))}

\item{.logit_offset}{A numberic value to modify values ofthe columns that are
either one or zero. They are modifed to be \code{x - offset} or \code{offset} respectively.}

\item{.ns_deg_free}{The degrees of freedom for the natural spline. As the
degrees of freedom for a natural spline increase, more flexible and complex
curves can be generated. When a single degree of freedom is used, the result
is a rescaled version of the original data.}

\item{.rel_shift}{A numeric value dictating a translation to apply to the data.}

\item{.rel_reverse}{A logical to indicate if theleft hinge should be used as
opposed to the right hinge.}

\item{.rel_smooth}{A logical indicating if hte softplus function, a smooth
approximation to the rectified linear transformation, should be used.}

\item{.yj_limits}{A length 2 numeric vector defining the range to compute the
transformation parameter lambda.}

\item{.yj_num_unique}{An integer where data that have less possible values
will not be evaluated for a transformation.}
}
\value{
A list object
}
\description{
Takes in a recipe and will perform the desired transformation on the selected
varialbe(s) using a selected recipe. To call the desired transformation
recipe use a quoted argument like "boxcos", "bs" etc. This function
is not exported but may be called via the ::: method.
}
\details{
This function will get your data ready for processing with many types of ml/ai
models.

This is intended to be used inside of the data processor and
therefore is an internal function. This documentation exists to explain the process
and help the user understand the parameters that can be set in the pre-processor function.

\code{\link[recipes:step_BoxCox]{recipes::step_BoxCox()}}
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))

date_seq <- seq.Date(from = as.Date("2013-01-01"), length.out = 100, by = "month")
val_seq  <- rep(rnorm(10, mean = 6, sd = 2), times = 10)
df_tbl   <- tibble(
    date_col = date_seq,
    value    = val_seq
)

rec_obj <- recipe(value ~., df_tbl)

healthyR.ai:::hai_data_transform(
    .recipe_object = rec_obj,
    value,
    .type_of_scale = "log"
)$scale_rec_obj \%>\%
    get_juiced_data()

}
\seealso{
\url{https://recipes.tidymodels.org/reference/step_BoxCox.html}

\code{\link[recipes:step_bs]{recipes::step_bs()}}

\url{https://recipes.tidymodels.org/reference/step_bs.html}

\code{\link[recipes:step_log]{recipes::step_log()}}

\url{https://recipes.tidymodels.org/reference/step_log.html}

\code{\link[recipes:step_logit]{recipes::step_logit()}}

\url{https://recipes.tidymodels.org/reference/step_logit.html}

\code{\link[recipes:step_ns]{recipes::step_ns()}}

\url{https://recipes.tidymodels.org/reference/step_ns.html}

\code{\link[recipes:step_relu]{recipes::step_relu()}}

\url{https://recipes.tidymodels.org/reference/step_relu.html}

\code{\link[recipes:step_sqrt]{recipes::step_sqrt()}}

\url{https://recipes.tidymodels.org/reference/step_sqrt.html}

\code{\link[recipes:step_YeoJohnson]{recipes::step_YeoJohnson()}}

\url{https://recipes.tidymodels.org/reference/step_YeoJohnson.html}

Other Data Recipes: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_trig}()},
\code{\link{pca_your_recipe}()}

Other Preprocessor: 
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_trig}()},
\code{\link{hai_knn_data_prepper}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Recipes}
\concept{Preprocessor}
