% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-linear-reg.R
\name{ts_wfs_lin_reg}
\alias{ts_wfs_lin_reg}
\title{Auto Linear Regression Workflowset Function}
\usage{
ts_wfs_lin_reg(.model_type, .recipe_list, .penalty = 1, .mixture = 0.5)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[parsnip:linear_reg]{parsnip::linear_reg()}} under the hood and can take one of the following:
\itemize{
\item "lm"
\item "glmnet"
\item "all_engines" - This will make a model spec for all available engines.
}

Not yet implemented are:
\itemize{
\item "stan"
\item "spark"
\item "keras"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.penalty}{The penalty parameter of the glmnet. The default is 1}

\item{.mixture}{The mixture parameter of the glmnet. The default is 0.5}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the \code{glmnet} model specification, but if you choose you can
set them yourself if you have a good understanding of what they should be.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(tidymodels))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_lin_reg("all_engines", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}(workflowsets)

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
