% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-tune-spec-template.R
\name{ts_model_spec_tune_template}
\alias{ts_model_spec_tune_template}
\title{Time Series Model Spec Template}
\usage{
ts_model_spec_tune_template(.parsnip_engine = NULL)
}
\arguments{
\item{.parsnip_engine}{The model engine that is used by \code{\link[parsnip:set_engine]{parsnip::set_engine()}}.}
}
\value{
A tuneable parsnip model specification.
}
\description{
This function will create a generic tuneable model specification, this function
can be used by itself and is called internally by \code{\link[=ts_model_auto_tune]{ts_model_auto_tune()}}.
}
\details{
This function takes in a single parameter and uses that to output a generic
tuneable model specification. This function can work with the following
parsnip/modeltime engines:
\itemize{
\item "auto_arima"
\item "auto_arima_xgboost"
\item "ets"
\item "croston"
\item "theta"
\item "smooth_es"
\item "stlm_ets"
\item "tbats"
\item "stlm_arima"
\item "nnetar"
\item "prophet"
\item "prophet_xgboost"
\item "lm"
\item "glmnet"
\item "stan"
\item "spark"
\item "keras"
\item "earth"
\item "xgboost"
}
}
\examples{
ts_model_spec_tune_template("ets")
ts_model_spec_tune_template("prophet")

}
\seealso{
Other Model Tuning: 
\code{\link{ts_model_auto_tune}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Helper}
\concept{Model Tuning}
