% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_hddm.R
\name{dfr_hddm}
\alias{dfr_hddm}
\title{Adapted Hoeffding Drift Detection Method (HDDM) method}
\usage{
dfr_hddm(
  drift_confidence = 0.001,
  warning_confidence = 0.005,
  two_side_option = TRUE
)
}
\arguments{
\item{drift_confidence}{Confidence to the drift}

\item{warning_confidence}{Confidence to the warning}

\item{two_side_option}{Option to monitor error increments and decrements (two-sided) or only increments (one-sided)}
}
\value{
\code{dfr_hddm} object
}
\description{
is a drift detection method based on the Hoeffding’s inequality. HDDM_A uses the average as estimator.  \url{doi:10.1109/TKDE.2014.2345382}.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example uses an error-based drift detector with a synthetic a 
# model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4

model <- dfr_hddm()

detection <- NULL
output <- list(obj=model, drift=FALSE)
for (i in 1:length(data$prediction)){
 output <- update_state(output$obj, data$prediction[i])
 if (output$drift){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, data.frame(idx=i, event=output$drift, type=type))
}

detection[detection$type == 'drift',]
}
