% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ac_stealthy.R
\name{stealthy}
\alias{stealthy}
\title{Stealthy}
\usage{
stealthy(
  model,
  drift_method,
  monitored_features = NULL,
  norm_class = daltoolbox::zscore(),
  warmup_size = 100,
  th = 0.5,
  target_uni_drifter = FALSE,
  incremental_memory = TRUE,
  verbose = FALSE,
  reporting = FALSE
)
}
\arguments{
\item{model}{The algorithm object to be used for predictions}

\item{drift_method}{The algorithm object to detect drifts}

\item{monitored_features}{List of features that will be monitored by the drifter}

\item{norm_class}{Class used to perform normalization}

\item{warmup_size}{Number of rows used to warmup the drifter. No drift will be detected during this phase}

\item{th}{The threshold to be used with classification algorithms}

\item{target_uni_drifter}{Passes the prediction target to the drifts as the target feat when the drifter is univariate and dist_based.}

\item{incremental_memory}{If true, the model will retrain with all available data whenever the fit is called. If false, it only retrains when a drift is detected.}

\item{verbose}{if TRUE shows drift messages}

\item{reporting}{If TRUE, some data are returned as norm_x_oh, drift_input, hist_proj, and recent_proj.}
}
\value{
Stealthy object
}
\description{
Ancestor class for drift adaptive models
}
\examples{
# See ?dd_ddm for an example of DDM drift detector
}
