% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{peng}
\alias{peng}
\title{Size measurements for penguins near Palmer Station, Antarctica}
\format{
A tibble with 333 rows and 8 variables:
\describe{
  \item{species}{a factor denoting penguin species (\code{"Adélie", "Chinstrap" or "Gentoo"})}
  \item{island}{a factor denoting island in Palmer Archipelago, Antarctica (\code{"Biscoe", "Dream" or "Torgersen"})}
  \item{bill_length}{a number denoting bill length (millimeters)}
  \item{bill_depth}{a number denoting bill depth (millimeters)}
  \item{flipper_length}{an integer denoting flipper length (millimeters)}
  \item{body_mass}{an integer denoting body mass (grams)}
  \item{sex}{a factor denoting penguin sex (\code{"f", "m"})}
  \item{year}{an integer denoting the study year (2007, 2008, or 2009)}
}
}
\source{
{Adélie penguins: Palmer Station Antarctica LTER and K. Gorman. 2020. 
  Structural size measurements and isotopic signatures of foraging among 
  adult male and female Adélie penguins (Pygoscelis adeliae) nesting along 
  the Palmer Archipelago near Palmer Station, 2007-2009 ver 5. Environmental 
  Data Initiative} \doi{10.6073/pasta/98b16d7d563f265cb52372c8ca99e60f}

{Gentoo penguins: Palmer Station Antarctica LTER and K. Gorman. 2020. 
  Structural size measurements and isotopic signatures of foraging among 
  adult male and female Gentoo penguin (Pygoscelis papua) nesting along the 
  Palmer Archipelago near Palmer Station, 2007-2009 ver 5. Environmental 
  Data Initiative} \doi{10.6073/pasta/7fca67fb28d56ee2ffa3d9370ebda689}

{Chinstrap penguins: Palmer Station Antarctica LTER and K. Gorman. 
  2020. Structural size measurements and isotopic signatures of foraging 
  among adult male and female Chinstrap penguin (Pygoscelis antarcticus) 
  nesting along the Palmer Archipelago near Palmer Station, 2007-2009 ver 6. 
  Environmental Data Initiative} \doi{10.6073/pasta/c14dfcfada8ea13a17536e73eb6fbe9e}

{Originally published in: Gorman K.B., Williams T.D., Fraser W.R. (2014) 
  Ecological Sexual Dimorphism and Environmental Variability within a 
  Community of Antarctic Penguins (Genus Pygoscelis). PLoS ONE 9(3): e90081.} 
  \doi{10.1371/journal.pone.0090081}
}
\usage{
peng
}
\description{
Data originally from \href{https://allisonhorst.github.io/palmerpenguins/}{\code{palmerpenguins}}. Includes
measurements for penguin species, island in Palmer Archipelago,
size (flipper length, body mass, bill dimensions), and sex.
}
\details{
In this version, variable names have been shortened (removing units) and observations with
missing data have been removed.
}
\examples{
data(peng)
# Covariance ellipses, centered, first two variables
covEllipses(cbind(bill_length, bill_depth) ~ species, data=peng,
     center=TRUE, 
     fill=c(rep(FALSE,3), TRUE), 
     fill.alpha=.1, label.pos=c(1:3,0))

# All pairs when more than two variables are specified. They look pretty similar
covEllipses(peng[,3:6], peng$species, 
            variables=1:4, 
            fill=c(rep(FALSE,3), TRUE), 
            fill.alpha=.1)
            
# Box's M test 	
peng.boxm <- boxM(cbind(bill_length, bill_depth, flipper_length, body_mass) ~ species, data=peng)
peng.boxm
plot(peng.boxm, gplabel="Species")

# Fit MANOVA model, predicting species 
peng.mod0 <-lm(cbind(bill_length, bill_depth, flipper_length, body_mass) ~
               species, data=peng)
car::Anova(peng.mod0)

# HE plot
heplot(peng.mod0, fill=TRUE, fill.alpha=0.1, 
       size="effect",
       xlim=c(35,52), ylim=c(14,20))

}
\keyword{datasets}
