% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{flow}
\alias{flow}
\title{HERE Traffic API: Flow}
\usage{
flow(aoi, min_jam_factor = 0, url_only = FALSE)
}
\arguments{
\item{aoi}{\code{sf} object, Areas of Interest (POIs) of geometry type \code{POLYGON}.}

\item{min_jam_factor}{numeric, only retrieve flow information with a jam factor greater than the value provided (\code{default = 0}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested traffic flow information.
}
\description{
Real-time traffic flow from the HERE 'Traffic' API in areas of interest (AOIs).
The traffic flow data contains speed and congestion information, which
corresponds to the status of the traffic at the time of the query.
}
\note{
The maximum width and height of the bounding box of the input AOIs is 1 degree.
This means that each polygon (= one row) in the AOI \code{sf} object should fit in a 1 x 1 degree bbox.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Real-time traffic flow
flow_data <- flow(
  aoi = aoi,
  url_only = TRUE
)
}
\references{
\href{https://www.here.com/docs/bundle/traffic-api-v7-api-reference/page/index.html}{HERE Traffic API: Flow}
}
