% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hero_adjacent.R
\name{plot.hero_adjacent}
\alias{plot.hero_adjacent}
\title{Plot a \code{hero_adjacent} object}
\usage{
\method{plot}{hero_adjacent}(x, ...)
}
\arguments{
\item{x}{A \code{hero_adjacent} object}

\item{...}{Additional arguments passed to
\code{\link[graphics]{image}}, or if the igraph package
is installed, \code{\link[igraph]{plot.igraph}}.}
}
\description{
Plot a \code{hero_adjacent} object.  \code{x$nbrs} is
used to construct a
\code{\link[Matrix]{sparseMatrix-class}} object.  The
default behavior is to plot the sparse matrix using the
\code{\link[graphics]{image}} function.  However, if the
igraph package is installed, a graph is made using
\code{\link[igraph]{graph_from_adjacency_matrix}} and
then plotted using \code{\link[igraph]{plot.igraph}}.
}
\examples{
coords = expand.grid(1:4, 1:4)
a = adjacent(coords, digits = 1)
plot(a)
}
