% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cea.R
\name{custom_table}
\alias{custom_table}
\title{Custom CEA summary table}
\usage{
custom_table(x, strategy, grp, custom_vars, FUN = NULL)
}
\arguments{
\item{x}{Matrix containing information on outcome variables for each simulation and strategy.}

\item{strategy}{Name of column denoting treatment strategy.}

\item{grp}{Name of column denoting subgroup}

\item{custom_vars}{Name of custom variables to calculate summary statistic for.}

\item{FUN}{summary statistic function.}
}
\value{
A data.table of summary statistics for each variable specified in 
\code{custom_vars}. By default, returns the mean, 2.5\%, and 97.5\% quantile of
each variable. Different summary statistics can be calculated using FUN. 
This function is used in \code{icea} and \code{icea_pw} to create the
 \code{custom.table} output.
}
\description{
Custom table summarizing outcomes from probabilistic sensitivity analysis.
}
\examples{
# simulation output
nsims <- 100
sim <- data.frame(sim = rep(seq(nsims), 4),
             c = c(rlnorm(nsims, 5, .1), rlnorm(nsims, 5, .1),
                    rlnorm(nsims, 11, .1), rlnorm(nsims, 11, .1)),
             e = c(rnorm(nsims, 8, .2), rnorm(nsims, 8.5, .1),
                   rnorm(nsims, 11, .6), rnorm(nsims, 11.5, .6)),
             strategy = rep(paste0("Strategy ", seq(1, 2)),
                           each = nsims * 2),
             grp = rep(rep(c("Group 1", "Group 2"),
                           each = nsims), 2)
)

# Custom summary table
custom.fun <- function(x) list(mean = mean(x), median = median(x),
                             quantile(x, c(.025, .975)))
custom_table(sim, strategy = "strategy", grp = "grp",
           custom_vars = "e", FUN = custom.fun)
}
