% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{create_params}
\alias{create_params}
\alias{create_params.lm}
\alias{create_params.flexsurvreg}
\alias{create_params.flexsurvreg_list}
\alias{create_params.partsurvfit}
\title{Create a parameter object from a fitted model}
\usage{
create_params(object, ...)

\method{create_params}{lm}(object, n = 1000, point_estimate = FALSE,
  ...)

\method{create_params}{flexsurvreg}(object, n = 1000,
  point_estimate = FALSE, ...)

\method{create_params}{flexsurvreg_list}(object, n = 1000,
  point_estimate = FALSE, ...)

\method{create_params}{partsurvfit}(object, n = 1000,
  point_estimate = FALSE, bootstrap = TRUE, max_errors = 0, ...)
}
\arguments{
\item{object}{A statistical model to randomly sample parameters from.}

\item{...}{Further arguments passed to or from other methods. Currently unused.}

\item{n}{Number of random observations to draw.}

\item{point_estimate}{If TRUE, then the point estimates are returned and
and no samples are drawn.}

\item{bootstrap}{If \code{bootstrap} is FALSE or not specified, then \code{n} parameter sets are 
drawn by sampling from a multivariate normal distribution. If \code{bootstrap} is TRUE, then 
parameters are bootstrapped using \code{\link{bootstrap}}.}

\item{max_errors}{Equivalent to the \code{max_errors} argument in \code{\link{bootstrap}}.}
}
\value{
An object prefixed by \code{params_}. Mapping between \code{create_params} 
and the classes of the returned objects are: 
\itemize{
\item{\code{create_params.lm} ->}{ \code{params_lm}}
\item{\code{create_params.flexsurvreg} ->}{ \code{params_surv}}
\item{\code{create_params.flexsurvreg_list} ->}{ \code{params_surv_list}}
\item{\code{create_params.partsurvfit} ->}{ \code{params_surv_list}}
}
}
\description{
\code{create_params} is a generic function for creating an object containing 
parameters from a fitted statistical model. If \code{point_estimate = FALSE},
then random samples from the posterior distribution are returned.
}
\examples{
# create_params.lm
fit <- stats::lm(costs ~ female, data = psm4_exdata$costs$medical)
n <- 5
params_lm <- create_params(fit, n = n)
head(params_lm$coefs)
head(params_lm$sigma)

# create_params.flexsurvreg
library("flexsurv")
fit <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                    data = ovarian, dist = "weibull")
n <- 5
params_surv_wei <- create_params(fit, n = n)
print(params_surv_wei$dist)
head(params_surv_wei$coefs)
}
\keyword{internal}
