% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-general.R
\name{stateprobs}
\alias{stateprobs}
\title{State probability object}
\description{
An object of class \code{stateprobs} returned by \code{\link[=sim_stateprobs]{sim_stateprobs()}} or from
\verb{$sim_stateprobs()} methods in model classes.
}
\section{Components}{

A \code{stateprobs} object inherits from \code{data.table} and contains
the following columns:

\describe{
\item{sample}{A random sample from the PSA.}
\item{strategy_id}{The treatment strategy ID.}
\item{patient_id}{The patient ID.}
\item{grp_id}{The subgroup ID.}
\item{state_id}{The health state ID.}
\item{t}{The time at which a state probability is computed.}
\item{prob}{The probability of being in a given health state.}
}

When simulating individual-level models, the \code{patient_id} column is
not included as state probabilities are computed by averaging across patients.

In cohort models, the object also contains \code{size} and \code{absorbing} attributes.
The \code{size} attribute is a numeric vector with the elements \code{n_samples},
\code{n_strategies}, \code{n_patients}, \code{n_states}, and
\code{n_times} denoting the number of samples, treatment strategies, patients,
health states, and times. The \code{absorbing} attribute is a numeric vector
containing the absorbing health states (see the \code{absorbing} field of the
\code{\link{CohortDtstmTrans}} class for more details).
}

