% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmatrix.R
\name{as_array3}
\alias{as_array3}
\alias{as_tbl2}
\title{Convert between 2D tabular objects and 3D arrays}
\usage{
as_array3(x)

as_tbl2(
  x,
  output = c("data.table", "data.frame", "matrix", "tpmatrix"),
  prefix = "",
  sep = "_"
)
}
\arguments{
\item{x}{For \code{as_array3()} a 2-dimensional tabular object where each row stores a flattened
square matrix ordered rowwise. Reasonable classes are \code{matrix}, \code{data.frame},
\code{data.table}, and \code{tpmatrix}. For \code{as_tbl2()} a 3-dimensional array
where each slice is a square matrix.}

\item{output}{The class of the object returned by the function. Either
a \code{data.table}, \code{data.frame}, \code{matrix}, or \code{\link{tpmatrix}}.}

\item{prefix, sep}{Arguments passed to \code{\link[=tpmatrix_names]{tpmatrix_names()}} for naming
the transition probability columns. The \code{states} argument is based on
the column names (i.e., names of the second dimension) of array;
if \code{NULL}, then states are named \code{s1}, ..., \code{sh} where h is
the number of states.}
}
\value{
For \code{as_array3()} a 3-dimensional array of square matrices;
for \code{as_tbl2()} a 2-dimensional tabular object as specified by \code{output}.
}
\description{
Convert a 2-dimensional tabular object where each row stores a flattened
square matrix to a 3-dimensional array of square matrices and vice versa.
This allows multiple transition matrices to be stored as either tabular objects
(e.g., matrices, data frames, etc) or as arrays.
}
\examples{
p_12 <- c(.7, .6)
pmat <- tpmatrix(
 C, p_12,
 0, 1
)
pmat

as_array3(pmat)
as_array3(as.matrix(pmat))
as_tbl2(as_array3(pmat))
as_tbl2(as_array3(pmat), prefix = "p_", sep = ".")
}
\seealso{
\code{\link{tpmatrix}}
}
