% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.R
\name{crit_MEE}
\alias{crit_MEE}
\title{Maximum Empirical Error criterion}
\usage{
crit_MEE(x, model, thres = 0, preds = NULL)
}
\arguments{
\item{x}{matrix of new designs, one point per row (size n x d)}

\item{model}{\code{homGP} or \code{hetGP} model, including inverse matrices}

\item{thres}{for contour finding}

\item{preds}{optional predictions at \code{x} to avoid recomputing if already done}
}
\description{
Computes MEE infill criterion
}
\examples{
## Infill criterion example
set.seed(42)
branin <- function(x){
  m <- 54.8104; s <- 51.9496
  if(is.null(dim(x))) x <- matrix(x, nrow = 1)
  xx <- 15 * x[,1] - 5; y <- 15 * x[,2]
  f <- (y - 5.1 * xx^2/(4 * pi^2) + 5 * xx/pi - 6)^2 + 10 * (1 - 1/(8 * pi)) * cos(xx) + 10
  f <- (f - m)/s
  return(f)
}

ftest <- function(x, sd = 0.1){
  if(is.null(dim(x))) x <- matrix(x, nrow = 1)
  return(apply(x, 1, branin) + rnorm(nrow(x), sd = sd))
}

ngrid <- 101; xgrid <- seq(0, 1, length.out = ngrid)
Xgrid <- as.matrix(expand.grid(xgrid, xgrid))
Zgrid <- ftest(Xgrid)

n <- 20
N <- 500
X <- Xgrid[sample(1:nrow(Xgrid), n),]
X <- X[sample(1:n, N, replace = TRUE),]
Z <- ftest(X)
model <- mleHetGP(X, Z, lower = rep(0.001,2), upper = rep(1,2))

critgrid <- apply(Xgrid, 1, crit_MEE, model = model)

filled.contour(matrix(critgrid, ngrid), color.palette = terrain.colors, main = "MEE criterion")

}
\references{
Ranjan, P., Bingham, D. & Michailidis, G (2008). 
Sequential experiment design for contour estimation from complex computer codes, 
Technometrics, 50, pp. 527-541. \cr \cr

Bichon, B., Eldred, M., Swiler, L., Mahadevan, S. & McFarland, J. (2008).
Efficient global  reliability  analysis  for  nonlinear  implicit  performance  functions, 
AIAA Journal, 46, pp. 2459-2468. \cr \cr

Lyu, X., Binois, M. & Ludkovski, M. (2018+). Evaluating Gaussian Process Metamodels and Sequential Designs for Noisy Level Set Estimation. arXiv:1807.06712. \cr
}
