% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-loading.R
\name{load_packages}
\alias{load_packages}
\title{Load and install packages}
\usage{
load_packages(
  ...,
  install_packages = TRUE,
  force_install = FALSE,
  show_outdated_packages = FALSE,
  default_loading_method = FALSE,
  return_library_statements = FALSE
)
}
\arguments{
\item{...}{list of package names.}

\item{install_packages}{whether to install the selected packages.}

\item{force_install}{whether to install packages even if they are installed already.}

\item{show_outdated_packages}{whether to show a list of packages which are outdated.}

\item{default_loading_method}{load according to the default R method using only \code{library()}}

\item{return_library_statements}{makes this function only return a string containing \code{library()} statements which can be paste into an R script.}
}
\value{
Returns invisibly a list with additional package information and results of installing/upgrading and loading.
}
\description{
Utility function to load and optionally install packages if they are missing. When the function terminates,
packages are installed (if necessary) and loaded. Upgradeable packages are shown.
}
\details{
\code{load_packages} optionally installs, upgrades and attaches packages to the work space for a list of specified packages.
}
\examples{
\dontrun{
# Package names given one-by-one or in a vector
load_packages(c('magrittr', 'dplyr'))
load_packages('magrittr', 'dplyr')

# Package names may be unquoted
load_packages(magrittr, dplyr)
load_packages('magrittr','dplyr', install_packages=FALSE)
}

}
\seealso{
\code{\link[utils]{install.packages}} for installation of new packages,
\code{\link[utils]{update.packages}} for updating outdated packages,
\code{\link[base]{library}} for load and attaching packages.

Other developer functions: 
\code{\link{crossref_description}()},
\code{\link{generic_implementations}()},
\code{\link{update_settings}()},
\code{\link{valid_pkgname}()}
}
\concept{developer functions}
