% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_predictors.R
\name{pruning_make_predictions}
\alias{pruning_make_predictions}
\title{pruning_make_predictions Make predictions for each test dataset row against each tree.}
\usage{
pruning_make_predictions(
  loop_count,
  j,
  alpha_df,
  current_tree,
  test,
  useIdentity,
  classify,
  colname = "collapse_this_node",
  pred_type = "fatbears"
)
}
\arguments{
\item{loop_count}{The current fold number.}

\item{j}{The current tree number.}

\item{alpha_df}{A dataframe containing the CCP generated subtrees.}

\item{current_tree}{The current decision tree in the hhcartr internal format.}

\item{test}{The test dataset.}

\item{useIdentity}{Whether the training data has been transformed with the householder transform.}

\item{classify}{Default is TRUE. Set TRUE for a classification problem and FALSE for a regression problem.}

\item{colname}{The column name in alpha_df that contains the list of internal node numbers
that will be collapsed in the current subtree. The default value is "collapse_this_node".}

\item{pred_type}{Is pruning_make_predictions being called with CCP generated subtrees or
fatbears generated subtrees. Can have a value of either "ccp" or "fatbears". The default
value is "fatbears".}
}
\value{
Returns a list of (new_df, subtree_accuracy_predictions_df).
}
\description{
This internal function is a front-end to function make_predictions for making
predictions on CCP generated subtrees.
}
