% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testbed.R
\name{testbed}
\alias{testbed}
\title{testbed - Test internal hhcartr functions.}
\usage{
testbed(
  X,
  y,
  most_freq_class,
  split_original,
  n_classes,
  max_features,
  test_func,
  n_features,
  X_matrix
)
}
\arguments{
\item{X}{Training data, the feature variables.}

\item{y}{Training data, the target variable.}

\item{most_freq_class}{The most frequent class in the target variable.}

\item{split_original}{boolean to indicate whether to split on original data or reflected data.}

\item{n_classes}{The number of classes in y.}

\item{max_features}{The maximum number of features to use when training random forests.}

\item{test_func}{The hhcartr function to be tested.}

\item{n_features}{The number of feature columns in the training dataset.}

\item{X_matrix}{The A-matrix - rows containing the most frequent class in the training dataset.}
}
\value{
Returns the output of the test_func to be tested (if it returns output).
}
\description{
This function allows the testing of internal hhcartr functions in a standalone fashion.
Function testbed requires an export so that it can be used by the devtools::check() and devtools::test()
functions. The currently supported values for parameter test_func are ["best_split_",
"split_using_original_data", "reflect_feature_space", "hhcart_reflect_feature_space_g",
"hhcartr_regressor_find_better_split"].
}
