% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHHH4.R
\name{plotHHH4_season_groups}
\alias{plotHHH4_season_groups}
\title{Plot Seasonality of a \code{hhh4} Fit by Group}
\usage{
plotHHH4_season_groups(
  x,
  component = "end",
  seasonStart = 1,
  conf.level = 0.95,
  conf.B = 999,
  col = 1:6,
  xlab = "time",
  ylab = "multiplicative effect",
  ...,
  refline.args = list(),
  yearline.args = list(),
  legend.args = list()
)
}
\arguments{
\item{x}{an object of class \code{"hhh4"}.}

\item{component}{character string indicating from which component
seasonality terms should be extracted.}

\item{seasonStart}{an integer defining the \code{\link{epochInYear}} that
starts a new season (by default the first).}

\item{conf.level, conf.B}{a confidence level for the pointwise confidence
intervals around the group-specific seasonal effects. The confidence
intervals are based on quantiles of \code{conf.B} samples from the
asymptotic multivariate normal distribution of the maximum likelihood
estimate. Alternatively, if \code{conf.level = NA}, the individual
samples are drawn instead of the confidence lines.
Set \code{conf.level = NULL} to disable confidence intervals.}

\item{col}{a vector of group-specific colors, recycled as necessary and
passed to \code{\link{matplot}}.}

\item{xlab, ylab, ...}{arguments passed to \code{\link{matplot}}.}

\item{refline.args}{a list of arguments for \code{\link{abline}} to change
the style of the horizontal reference line at 1.
This line is omitted if \code{refline.args} is not a list.}

\item{yearline.args}{a list of arguments for \code{\link{abline}} to change
the style of the line marking the end of the year at
\code{x$stsObj@freq} if \code{seasonStart} is not 1.
This line is omitted if \code{yearline.args} is not a list.}

\item{legend.args}{a list of arguments for \code{\link{legend}} modifying
the internal defaults. If \code{legend.args} is not a list, the legend
is omitted.}
}
\value{
a matrix of the plotted point estimates of the multiplicative
    seasonal effect by group.
}
\description{
A plot method for models with group-specific seasonality terms that are not
handled correctly by \code{\link{plotHHH4_season}}.
}
