\name{HHSpectrum}
\alias{HHSpectrum}
\title{Generate Hilbert spectrum}
\description{
Generates a Hilbert periodogram from the results of \code{\link{Sig2IMF}} and \code{\link{EEMD}}.
}
\usage{
HHSpectrum(hres, dfreq, freq.span = NULL, time.span = NULL, 
    scaling = "none", verbose = TRUE)
}
\arguments{
\item{hres}{This is the output generated by \code{\link{EEMDCompile}} or \code{\link{EEMDResift}}}
\item{dfreq}{Frequency resolution of spectrum}
\item{time.span}{Time span to render spectrum over; \code{NULL} means over the whole time series}
\item{freq.span}{Frequency span to include in spectrum; \code{NULL} means render all the frequencies in the time series}
\item{scaling}{If \code{"log"}, render a log10 frequency spectrum.  Defaults to \code{"none"} (linear).}
\item{verbose}{If \code{TRUE}, print progress messages}
}
\details{
\code{HHSpectrum} sums Hilbert spectral data over the time domain to produce the equivalent of a periodogram.  
The result can be plotted using \code{\link{HHSpecPlot}}.
}
\value{ 
\item{hspec}{A data structure containing the spectrum of each IMF.}
}

\author{Daniel Bowman \email{danny.c.bowman@gmail.com}}

\seealso{
\code{\link{HHRender}}, \code{\link{HHSpecPlot}}
}
\examples{

\dontrun{
data(PortFosterEvent)

emd.result <- Sig2IMF(sig, tt)

dfreq <- 0.1
hspec <- HHSpectrum(emd.result, dfreq)
HHSpecPlot(hspec, show.fourier = TRUE, scale.fourier = TRUE)

}

}
\keyword{ts}
