% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVCF.R
\name{read.VCF}
\alias{read.VCF}
\title{Reads a VCF file into a BED object}
\usage{
read.VCF(fname,BiAllelic=TRUE,...)
}
\arguments{
\item{fname}{VCF file name. The VCF file can be compressed (VCF.gz)}

\item{BiAllelic}{Logical. If TRUE, only bi-allelic SNPs are retained,
otherwise, all variant are kept}

\item{...}{other arguments to pass to the function}
}
\value{
A \code{\link[gaston]{bed.matrix-class}} object
}
\description{
Reads a \url{https://samtools.github.io/hts-specs/}{Variant Call Format (VCF)} file into a BED object,
retaining bi-allelic SNPs only
}
\examples{
 
 filepath <-system.file("extdata", "LCT.vcf.gz", package="gaston")
 x1 <- read.VCF( filepath )
 x1

}
\seealso{
\code{\link[gaston]{read.vcf}}
}
