\name{CLX.sim.Covtest}
\alias{CLX.sim.Covtest}
\title{Cai, Liu, and Xia equal means test simulator
}
\description{Performs the test in Cai, Liu, and Xia (2014) for testing equality of two mean vectors on multiple data sets generated by \code{\link{build2popData}}, performing on each data set the test for equal covariance matrices found in Cai, Liu, and Xia (2013).

}
\usage{
CLX.sim.Covtest(DATA)
}

\arguments{
  \item{DATA}{an object returned by \code{\link{build2popData}}.
}
}

\value{ A data frame with columns
	\item{TSvalues}{values of the test statistic.}
	\item{pvalues}{the p values.}
}
\references{ 

	Cai, T., Liu, W. and Xia, Y. (2013). Two-sample covariance matrix testing and support recovery. 
	\emph{Journal of the American Statistical Association} \bold{108}, 265277.

	Cai, T. T., Liu, W. and Xia, Y. (2014). Two-sample test of high dimensional means under dependence.
	\emph{J. R. Statist. Soc. B.}

}
\author{
Karl Gregory  \email{kgregory@mail.uni-mannheim.de}, \url{http://www.stat.tamu.edu/~kbgregory}.
}

\seealso{
\code{\link{CLX.Covtest}}
}
\examples{
	
\dontrun{
DATA <-build2popData(	
	n = 15,
	m = 20,
	p = 500,
	muX = rep(0,500),
	muY = rep(0,500),
	commoncov = FALSE,
	VarScaleY = 1,
	dep = "ARMA",
	ARMAparms = list(coefs=list(ma=c(.2,.3) , ar=c(.4,-.1))),
	LRparm = .75,
	S = 25,
	innov = function(n,...) rnorm(n,0,1),
	heteroscedastic=TRUE,
	het.diag = diag(.1 + rexp(500,1/2))
	)	
CLX.sim.Covtest(DATA)

}
}

\keyword{htest}
\keyword{multivariate}
