\name{SK.sim}
\alias{SK.sim}
\title{Srivastava and Kubokawa Simulator

}
\description{Performs the test from Srivastava and Kubokawa (2013) on multiple data sets generated by \code{\link{build2popData}}.

}
\usage{
SK.sim(DATA)
}

\arguments{
  \item{DATA}{an object returned by \code{\link{build2popData}}.
}
}

\value{ A data frame with columns
	\item{TSvalues}{values of the test statistic.
	}
	\item{pvalues}{the p values.
	}
}
\references{ 

	Srivastava, M. S. and Kubokawa, T. (2013). Tests for multivariate analysis of variance in high dimension under non-normality. 
		\emph{Journal of Multivariate Analysis} \bold{115}, 204216.	
}
\author{
Karl Gregory   \email{kgregory@mail.uni-mannheim.de}, \url{http://www.stat.tamu.edu/~kbgregory}.
}

\seealso{
\code{\link{SK.test}}
}
\examples{
	
\dontrun{
DATA <-build2popData(	
	n = 15,
	m = 20,
	p = 500,
	muX = rep(0,500),
	muY = rep(0,500),
	commoncov = FALSE,
	VarScaleY = 1,
	dep = "ARMA",
	ARMAparms = list(coefs=list(ma=c(.2,.3) , ar=c(.4,-.1))),
	LRparm = .75,
	S = 25,
	innov = function(n,...) rnorm(n,0,1),
	heteroscedastic=TRUE,
	het.diag = diag(.1 + rexp(500,1/2))
	)	
	
SK.sim(DATA)

}
}

\keyword{htest}
\keyword{multivariate}
