\name{highD2pop-package}
\alias{highD2pop-package}
\alias{highD2pop}
\docType{package}
\title{ Two-sample tests for equality of means in high dimension
}
\description{
This package provides functions for the tests from Gregory et al. (2015), Chen and Qin (2010), Srivastava and Kubokawa (2013), and Cai, Liu, and Xia (2014) for the equal means hypothesis in the high-dimensional, two-population setting.  These are used to test \deqn{  H_0: \boldsymbol{\mu}_1 =  \boldsymbol{\mu}_2 } \deqn{H_1: \boldsymbol{\mu}_1 \neq  \boldsymbol{\mu}_2 }
when the number of components in the mean vectors exceeds the sample size, that is in the \emph{large-p-small-n} setting.
}
\details{
\tabular{ll}{
Package: \tab highD2pop\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-11-02\cr
License: \tab GPL (>=2)\cr
}

The functions \code{\link{GCT.test}}, \code{\link{ChenQin.test}} and \code{\link{SK.test}}, \code{\link{CLX.test.equalcov}} and \code{\link{CLX.test.unequalcov}}, accept \code{n} by \code{p} and \code{m} by \code{p} data matrices with sample data from the first and second populations and return test statistics and p-values for the null hypothesis of equal means.  The \code{\link{build2popData}} function simulates high-dimensional data in the two-population setting with specified sample sizes, numbers of components, covariance structure, etc., and the functions \code{\link{GCT.sim}}, \code{\link{ChenQin.sim}}, \code{\link{SK.sim}}, and \code{\link{CLX.sim.Covtest}} return test statistic values and p-values for lists of simulated data sets generated by \code{\link{build2popData}}. The \code{\link{CLX.Covtest}} function tests for equality of covariance matrices between the two populations with the test proposed in Cai, Liu, and Xia (2013). The \code{\link{GCT.test.missing}} is a version of the generalized component test which accomodates missing values and returns overall and componentwise missingness summaries. The functions \code{\link{rdblepareto}} and \code{\link{rgammashift}} generate realizations from heavy-tailed and skewed distributions under which the relative performance of the four tests is of interest.

% talk about data

}
\author{
Karl Gregory
Maintainer: Karl Gregory  <kgregory@mail.uni-mannheim.de>
}
\references{
	Cai, T., Liu, W. and Luo, X. (2011). A constrained l-1 minimization approach to sparse precision matrix estimation. 
		\emph{Journal of the American Statistical Association} \bold{106}, 594607.

	Cai, T., Liu, W. and Xia, Y. (2013). Two-sample covariance matrix testing and support recovery. 
		\emph{Journal of the American Statistical Association} \bold{108}, 265277.

	Cai, T. T., Liu, W. and Xia, Y. (2014). Two-sample test of high dimensional means under dependence.
		\emph{J. R. Statist. Soc. B.}

	Chen, X. S. and Qin, Y.L. (2010). A two sample test for high dimensional data with applications to gene-set testing.  		
		\emph{The Annals of Statistics}. \bold{38}(2):808--835

	Gregory, K., Carroll, R. J., Baladandayuthapani, V. and Lahiri, S. (2015). A two-sample test for equality of means in high dimension. 
		\emph{Journal of the American Statistician}, to appear
	
	Hall, P. Jing, B. Y. and Lahiri, S. N. (1998). On the sampling window method for long-range dependent data.
		\emph{Statistica Sinica} \bold{8},1189--1204

	Srivastava, M. S. and Kubokawa, T. (2013). Tests for multivariate analysis of variance in high dimension under non-normality. 
		\emph{Journal of Multivariate Analysis} \bold{115}, 204216.	
	
}

\keyword{package}

\examples{
	
	
data(chr1qseg)

impute<-function(x) { 	x[which(is.na(x))] <- mean(x,na.rm=TRUE)
						return(x)
					}

X <- apply(chr1qseg$X,2,impute)
Y <- apply(chr1qseg$Y,2,impute)

## on imputed data with no missing values:

ChenQin.test(X,Y)
GCT.test(X,Y,r=20,smoother="parzen")
SK.test(X,Y)

## on raw data with missing values:

GCT.test.missing(chr1qseg$X,chr1qseg$Y,r=20,smoother="parzen")

}
