% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts-ts-xts.R
\name{hc_add_series_times_values}
\alias{hc_add_serie_times_values}
\alias{hc_add_series_times_values}
\title{Shorcut for create/add time series from times and values}
\usage{
hc_add_series_times_values(hc, dates, values, ...)

hc_add_serie_times_values(hc, dates, values, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{dates}{A date vector (same length as \code{values})}

\item{values}{A numeric vector}

\item{...}{Aditional arguments for the data series (\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function add a time series to a \code{highchart} object.
}
\details{
This function \bold{modify} the type of \code{chart} to \code{datetime}
}
\examples{

\dontrun{

require("ggplot2")
data(economics, package = "ggplot2")

hc_add_series_times_values(hc = highchart(),
                           dates = economics$date,
                           values = economics$psavert, 
                           name = "Personal Savings Rate")
}

}

