% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_responsive}
\alias{hc_responsive}
\title{Setting responsive options to highchart objects}
\usage{
hc_responsive(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts/responsive}.}
}
\description{
Allows setting a set of rules to apply for different screen or chart sizes.
Each rule specifies additional chart options.
}
\examples{

leg_500_opts <- list(enabled = FALSE)
leg_900_opts <- list(align = "right", verticalAlign = "middle",  layout = "vertical")

highcharts_demo() \%>\% 
  hc_responsive(
    rules = list(
      # remove legend if there is no much space
      list(
        condition = list(maxWidth  = 500),
        chartOptions = list(legend = leg_500_opts)
      ),
      # put legend on the right when there is much space
      list(
        condition = list(minWidth  = 900),
        chartOptions = list(legend = leg_900_opts)
      )
    )
  )
             
}
