% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rAVGCov}
\alias{rAVGCov}
\title{Realized Covariance: Average Subsample}
\usage{
rAVGCov(rdata, cor = FALSE, align.by = "minutes", align.period = 5,
  makeReturns = FALSE)
}
\arguments{
\item{rdata}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{align.by}{Align the tick data to seconds|minutes|hours}

\item{align.period}{Align the tick data to this many [seconds|minutes|hours]}

\item{makeReturns}{Prices are passed make them into log returns}
}
\value{
Realized covariance using average subsample.
}
\description{
Realized Covariance using average subsample.
}
\examples{
# Average subsampled realized variance/covariance aligned at one minute returns at 
# 5 subgrids (5 minutes).

# Univariate
rvSub <- rAVGCov(rdata = sample_tdata$PRICE, align.by = "minutes",
                 align.period = 5, makeReturns = TRUE) 
rvSub

# Multivariate:
rcovSub <- rAVGCov(rdata = cbind(lltc, sbux, fill = 0), align.by = "minutes", 
                   align.period = 5, makeReturns = FALSE)
rcovSub

}
\references{
L. Zhang, P.A Mykland, and Y. Ait-Sahalia. A tale of two time scales: Determining integrated volatility with noisy high-frequency data. \emph{Journal of the American Statistical Association}, 2005.

Michiel de Pooter, Martin Martens, and Dick van Dijk. Predicting the daily covariance matrix for S\&P100 stocks using intraday data - but which frequency to use? \emph{Econometric Reviews}, 2008.
}
\author{
Scott Payseur
}
\keyword{volatility}
