% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driftBursts.R
\name{print.DBH}
\alias{print.DBH}
\title{Printing method for \code{DBH} objects}
\usage{
\method{print}{DBH}(x, ...)
}
\arguments{
\item{x}{an object of class \code{DBH}}

\item{...}{optional arguments, see details}
}
\description{
Printing method for \code{DBH} objects
}
\details{
The print method has the following optional parameters:
\itemize{
\item{\code{criticalValue}}{ A numeric denoting a custom critical value of the test.}
\item{\code{alpha}}{ A numeric denoting the confidence level of the test. The alpha value is passed on to \code{\link{getCriticalValues}}.
The default value is 0.95}
}
}
\examples{
\dontrun{
DBH <- driftBursts(sampleTDataEurope, testTimes = seq(32400 + 900, 63000, 300), preAverage = 2, 
                   ACLag = -1L, meanBandwidth = 300L, varianceBandwidth = 900L)
print(DBH)
print(DBH, criticalValue = 1) # This value doesn't make sense - don't actually use it!
print(DBH, alpha = 0.95) # 5\% confidence level - this is the standard
print(DBH, alpha = 0.99) # 1\% confidence level
}
}
\author{
Emil Sjoerup
}
