% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_profile_plot.R
\name{div_profile_plot}
\alias{div_profile_plot}
\title{Diversity profile plot}
\usage{
div_profile_plot(profile, colour, log, legend)
}
\arguments{
\item{profile}{A div_profile() object or a vector/matrix containg diversity profile(s), with columns indicating samples/groups and rows indicating orders of diversity (q-values).}

\item{colour}{A vector of RGB colours e.g. c("#34k235","#99cc00"). The number of vector items, must equal the number of samples or groups that are intended to plot.}

\item{log}{Whether to transform Hill numbers to logarithmic scale (TRUE) or not (FALSE). This is useful when there are large differences between q values (e.g. sharp drop from q=0 to q=1), which might complicate visualization. Default: log=FALSE}

\item{legend}{Whether to display the legend (TRUE) or not (FALSE) in diversity profiles containing multiple samples/groups. Default TRUE in multi-sample charts.}
}
\value{
A diversity profile plot.
}
\description{
Plot diversity profiles from objects generated with the function div_profile().
}
\details{
Diversity profile plot
}
\examples{
data(bat.diet.otutable)
data(bat.diet.hierarchy)
#One sample example
bat.diet.sample <- bat.diet.otutable[,1]
profile.onesample <- div_profile(count=bat.diet.sample,qvalues=seq(from = 0, to = 5, by = (0.1)))
div_profile_plot(profile.onesample)
#Multiple samples
profile.multiplesamples <- div_profile(bat.diet.otutable)
div_profile_plot(profile.multiplesamples)
#Multiple groups (gamma diversity)
profile.multiplegroups <- div_profile(bat.diet.otutable,hierarchy=bat.diet.hierarchy,level="gamma")
div_profile_plot(profile.multiplegroups)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Jost, L. (2014). Unifying species diversity, phylogenetic diversity, functional diversity, and related similarity and differentiation measures through hill numbers. Annual Review of Ecology Evolution and Systematics, 45, 297-324.
}
\seealso{
\code{\link{div_profile}}, \code{\link{hill_div}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{alpha}
\keyword{beta}
\keyword{gamma}
\keyword{hill}
