% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_data.R
\name{match_data}
\alias{match_data}
\title{Match data}
\usage{
match_data(countable, tree, output)
}
\arguments{
\item{countable}{A count table (matrix/data.frame) indicating the absolute or relative OTU/ASV abundances of multiple samples. Columns must refer to samples and rows to OTUs/ASVs.}

\item{tree}{An ultrametic tree of class 'phylo'.}

\item{output}{Whether to output a filtered count table ('countable') or a filtered OTU tree ('tree').}
}
\description{
Filter count tables and OTU/ASV phylogenetic trees to match OTUs/ASVs present in both data files..
}
\details{
Match data
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
match_data(bat.diet.otutable,bat.diet.tree,output="countable")
match_data(bat.diet.otutable,bat.diet.tree,output="tree")
}
\seealso{
\code{\link{hill_div}}, \code{\link{index_div}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{ASV}
\keyword{OTU}
\keyword{names}
\keyword{tree}
