% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{as.hierarchy}
\alias{as.hierarchy}
\title{Hierarchy Structure}
\usage{
as.hierarchy(x, max.height, height, names)
}
\arguments{
\item{x}{A S3 object.}

\item{max.height}{Is the maximal height below the global node height which 
is considered.}

\item{height}{A vector of heights at which nodes are grouped.}

\item{names}{Variable names in the order in which the indexes shut be given 
to the variables.}

\item{...}{Further arguments.}
}
\description{
Stores variable indexes of clustering hierarchies in a fast 
accessible manner.
}
\details{
For the HIT algorithm it is important to have the hierarchical 
clustering structure in a fast accessible format. This is provided by the 
hierarchy object generated with this function.
}
\examples{
##
set.seed(123)
n <- 80
p <- 90
# x with correlated columns
corMat <- toeplitz((p:1/p)^3)
corMatQ <- chol(corMat)
x <- matrix(rnorm(n * p), nrow = n) \%*\% corMatQ
colnames(x) <- paste0("x", 1:p)
# hierarchy
hc <- hclust(dist(t(x)))
hier <- as.hierarchy(hc)

}

