% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.plot.R
\name{mcmc.plot}
\alias{mcmc.plot}
\title{Markov chains plotting}
\usage{
mcmc.plot(fit, mfrow, plot.spatial)
}
\arguments{
\item{fit}{A named list.
Output from the \code{hkevp.fit} procedure.}

\item{mfrow}{A vector of two numerical values.
Parameter of the window plotting called by the \code{plot(...)} function. Optional.}

\item{plot.spatial}{Logical.
Should the Markov chains of the sills and ranges hyperparameters should be plotted (FALSE by default)?}
}
\description{
Plot of the resulting Markov chains obtained by the MCMC procedure \code{hkevp.fit}. May be used to assess graphically convergence of the chains.
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
mu <- sites[,1]*10
sigma <- 3
xi <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, mu, sigma, xi, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, knots, niter = 100, nburn = 50, quiet = FALSE)

# Markov chains plot:
# mcmc.plot(fit)



}
\author{
Quentin Sebille
}
\seealso{
\link{mcmc.accept}
}

