% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-eval-mism.R
\name{EvalAlleleMism}
\alias{EvalAlleleMism}
\title{Evaluate mismatched alleles}
\usage{
EvalAlleleMism(don_1, don_2, recip_1, recip_2, hmz_cnt = 1)
}
\arguments{
\item{don_1}{Donor's alpha1 domain.}

\item{don_2}{Donor's alpha2 or beta1 domain.}

\item{recip_1}{Recipient's alpha1 domain.}

\item{recip_2}{Recipient's alpha2 or beta1 domain.}

\item{hmz_cnt}{Use hmz_cnt to determine how mismatch at homozygous alleles should be handled. By default, a mismatch at a homozygous allele is considered a single mismatch. Set hmz_cnt = 2 to count homozygous mismatches as double.}
}
\value{
A data frame of original input columns followed by mism_cnt of each donor/recipient pair.
}
\description{
Compare donor and recipient HLA(Human Leukocyte Antigen) typing data to determine mismatched alleles. Input data can be high or low resolution, mismatch is evaluated at the allele level.
}
\examples{
dat <- read.csv(system.file("extdata/example", "HLA_Clean_test.csv", package = "hlaR"))
re <- EvalAlleleMism(dat$donor_a1, dat$donor_a2, dat$recipient_a1, dat$recipient_a2, hmz_cnt = 2)
}
